/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import skeletonapplet.Utilities;

public class CheckJar {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(File file) {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byArray = Utilities.readBytes(fileInputStream);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
            }
        }
        return byArray;
    }

    public static long getChecksum(byte[] byArray) {
        if (byArray == null) {
            return -1L;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static long getChecksum(File file) {
        return CheckJar.getChecksum(CheckJar.getBytes(file));
    }

    public static int getLength(byte[] byArray) {
        return byArray == null ? -1 : byArray.length;
    }

    public static boolean isValidJarFile(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                jarEntry.getSize();
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return false;
        }
        return true;
    }

    public static boolean isValidZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                zipEntry.getSize();
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file = new File(string);
            byte[] byArray = CheckJar.getBytes(file);
            int n = CheckJar.getLength(byArray);
            long l = CheckJar.getChecksum(byArray);
            boolean bl = CheckJar.isValidJarFile(file);
            System.out.println(string + "\t" + n + "\t" + l + "\t" + bl);
        }
    }
}

